<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Lime color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface LimeColorProviderInterface extends ColorProviderInterface {

    /**
     * Lime color "100"
     *
     * @var string
     */
    const LIME_COLOR_100 = "#F0F4C3";

    /**
     * Lime color "200"
     *
     * @var string
     */
    const LIME_COLOR_200 = "#E6EE9C";

    /**
     * Lime color "300"
     *
     * @var string
     */
    const LIME_COLOR_300 = "#DCE775";

    /**
     * Lime color "400"
     *
     * @var string
     */
    const LIME_COLOR_400 = "#D4E157";

    /**
     * Lime color "50"
     *
     * @var string
     */
    const LIME_COLOR_50 = "#F9FBE7";

    /**
     * Lime color "500"
     *
     * @var string
     */
    const LIME_COLOR_500 = "#CDDC39";

    /**
     * Lime color "600"
     *
     * @var string
     */
    const LIME_COLOR_600 = "#C0CA33";

    /**
     * Lime color "700"
     *
     * @var string
     */
    const LIME_COLOR_700 = "#AFB42B";

    /**
     * Lime color "800"
     *
     * @var string
     */
    const LIME_COLOR_800 = "#9E9D24";

    /**
     * Lime color "900"
     *
     * @var string
     */
    const LIME_COLOR_900 = "#827717";

    /**
     * Lime color "A100"
     *
     * @var string
     */
    const LIME_COLOR_A100 = "#F4FF81";

    /**
     * Lime color "A200"
     *
     * @var string
     */
    const LIME_COLOR_A200 = "#EEFF41";

    /**
     * Lime color "A400"
     *
     * @var string
     */
    const LIME_COLOR_A400 = "#C6FF00";

    /**
     * Lime color "A700"
     *
     * @var string
     */
    const LIME_COLOR_A700 = "#AEEA00";

    /**
     * Lime color name.
     *
     * @var string
     */
    const LIME_COLOR_NAME = "lime";
}
