<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Orange color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface OrangeColorProviderInterface extends ColorProviderInterface {

    /**
     * Orange color "100"
     *
     * @var string
     */
    const ORANGE_COLOR_100 = "#FFE0B2";

    /**
     * Orange color "200"
     *
     * @var string
     */
    const ORANGE_COLOR_200 = "#FFCC80";

    /**
     * Orange color "300"
     *
     * @var string
     */
    const ORANGE_COLOR_300 = "#FFB74D";

    /**
     * Orange color "400"
     *
     * @var string
     */
    const ORANGE_COLOR_400 = "#FFA726";

    /**
     * Orange color "50"
     *
     * @var string
     */
    const ORANGE_COLOR_50 = "#FFF3E0";

    /**
     * Orange color "500"
     *
     * @var string
     */
    const ORANGE_COLOR_500 = "#FF9800";

    /**
     * Orange color "600"
     *
     * @var string
     */
    const ORANGE_COLOR_600 = "#FB8C00";

    /**
     * Orange color "700"
     *
     * @var string
     */
    const ORANGE_COLOR_700 = "#F57C00";

    /**
     * Orange color "800"
     *
     * @var string
     */
    const ORANGE_COLOR_800 = "#EF6C00";

    /**
     * Orange color "900"
     *
     * @var string
     */
    const ORANGE_COLOR_900 = "#E65100";

    /**
     * Orange color "A100"
     *
     * @var string
     */
    const ORANGE_COLOR_A100 = "#FFD180";

    /**
     * Orange color "A200"
     *
     * @var string
     */
    const ORANGE_COLOR_A200 = "#FFAB40";

    /**
     * Orange color "A400"
     *
     * @var string
     */
    const ORANGE_COLOR_A400 = "#FF9100";

    /**
     * Orange color "A700"
     *
     * @var string
     */
    const ORANGE_COLOR_A700 = "#FF6D00";

    /**
     * Orange color name.
     *
     * @var string
     */
    const ORANGE_COLOR_NAME = "orange";
}
