<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Purple color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface PurpleColorProviderInterface extends ColorProviderInterface {

    /**
     * Purple color "100"
     *
     * @var string
     */
    const PURPLE_COLOR_100 = "#E1BEE7";

    /**
     * Purple color "200"
     *
     * @var string
     */
    const PURPLE_COLOR_200 = "#CE93D8";

    /**
     * Purple color "300"
     *
     * @var string
     */
    const PURPLE_COLOR_300 = "#BA68C8";

    /**
     * Purple color "400"
     *
     * @var string
     */
    const PURPLE_COLOR_400 = "#AB47BC";

    /**
     * Purple color "50"
     *
     * @var string
     */
    const PURPLE_COLOR_50 = "#F3E5F5";

    /**
     * Purple color "500"
     *
     * @var string
     */
    const PURPLE_COLOR_500 = "#9C27B0";

    /**
     * Purple color "600"
     *
     * @var string
     */
    const PURPLE_COLOR_600 = "#8E24AA";

    /**
     * Purple color "700"
     *
     * @var string
     */
    const PURPLE_COLOR_700 = "#7B1FA2";

    /**
     * Purple color "800"
     *
     * @var string
     */
    const PURPLE_COLOR_800 = "#6A1B9A";

    /**
     * Purple color "900"
     *
     * @var string
     */
    const PURPLE_COLOR_900 = "#4A148C";

    /**
     * Purple color "A100"
     *
     * @var string
     */
    const PURPLE_COLOR_A100 = "#EA80FC";

    /**
     * Purple color "A200"
     *
     * @var string
     */
    const PURPLE_COLOR_A200 = "#E040FB";

    /**
     * Purple color "A400"
     *
     * @var string
     */
    const PURPLE_COLOR_A400 = "#D500F9";

    /**
     * Purple color "A700"
     *
     * @var string
     */
    const PURPLE_COLOR_A700 = "#AA00FF";

    /**
     * Purple color name.
     *
     * @var string
     */
    const PURPLE_COLOR_NAME = "purple";
}
