<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Teal color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface TealColorProviderInterface extends ColorProviderInterface {

    /**
     * Teal color "100"
     *
     * @var string
     */
    const TEAL_COLOR_100 = "#B2DFDB";

    /**
     * Teal color "200"
     *
     * @var string
     */
    const TEAL_COLOR_200 = "#80CBC4";

    /**
     * Teal color "300"
     *
     * @var string
     */
    const TEAL_COLOR_300 = "#4DB6AC";

    /**
     * Teal color "400"
     *
     * @var string
     */
    const TEAL_COLOR_400 = "#26A69A";

    /**
     * Teal color "50"
     *
     * @var string
     */
    const TEAL_COLOR_50 = "#E0F2F1";

    /**
     * Teal color "500"
     *
     * @var string
     */
    const TEAL_COLOR_500 = "#009688";

    /**
     * Teal color "600"
     *
     * @var string
     */
    const TEAL_COLOR_600 = "#00897B";

    /**
     * Teal color "700"
     *
     * @var string
     */
    const TEAL_COLOR_700 = "#00796B";

    /**
     * Teal color "800"
     *
     * @var string
     */
    const TEAL_COLOR_800 = "#00695C";

    /**
     * Teal color "900"
     *
     * @var string
     */
    const TEAL_COLOR_900 = "#004D40";

    /**
     * Teal color "A100"
     *
     * @var string
     */
    const TEAL_COLOR_A100 = "#A7FFEB";

    /**
     * Teal color "A200"
     *
     * @var string
     */
    const TEAL_COLOR_A200 = "#64FFDA";

    /**
     * Teal color "A400"
     *
     * @var string
     */
    const TEAL_COLOR_A400 = "#1DE9B6";

    /**
     * Teal color "A700"
     *
     * @var string
     */
    const TEAL_COLOR_A700 = "#00BFA5";

    /**
     * Teal color name.
     *
     * @var string
     */
    const TEAL_COLOR_NAME = "teal";
}
