<?php

/*
 * This file is part of the core-library package.
 *
 * (c) 2018 WEBEWEB
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace WBW\Library\Symfony\Provider\Color;

use WBW\Library\Symfony\Provider\ColorProviderInterface;

/**
 * Yellow color provider interface.
 *
 * @author webeweb <https://github.com/webeweb>
 * @package WBW\Library\Symfony\Provider\Color
 */
interface YellowColorProviderInterface extends ColorProviderInterface {

    /**
     * Yellow color "100"
     *
     * @var string
     */
    const YELLOW_COLOR_100 = "#FFF9C4";

    /**
     * Yellow color "200"
     *
     * @var string
     */
    const YELLOW_COLOR_200 = "#FFF59D";

    /**
     * Yellow color "300"
     *
     * @var string
     */
    const YELLOW_COLOR_300 = "#FFF176";

    /**
     * Yellow color "400"
     *
     * @var string
     */
    const YELLOW_COLOR_400 = "#FFEE58";

    /**
     * Yellow color "50"
     *
     * @var string
     */
    const YELLOW_COLOR_50 = "#FFFDE7";

    /**
     * Yellow color "500"
     *
     * @var string
     */
    const YELLOW_COLOR_500 = "#FFEB3B";

    /**
     * Yellow color "600"
     *
     * @var string
     */
    const YELLOW_COLOR_600 = "#FDD835";

    /**
     * Yellow color "700"
     *
     * @var string
     */
    const YELLOW_COLOR_700 = "#FBC02D";

    /**
     * Yellow color "800"
     *
     * @var string
     */
    const YELLOW_COLOR_800 = "#F9A825";

    /**
     * Yellow color "900"
     *
     * @var string
     */
    const YELLOW_COLOR_900 = "#F57F17";

    /**
     * Yellow color "A100"
     *
     * @var string
     */
    const YELLOW_COLOR_A100 = "#FFFF8D";

    /**
     * Yellow color "A200"
     *
     * @var string
     */
    const YELLOW_COLOR_A200 = "#FFFF00";

    /**
     * Yellow color "A400"
     *
     * @var string
     */
    const YELLOW_COLOR_A400 = "#FFEA00";

    /**
     * Yellow color "A700"
     *
     * @var string
     */
    const YELLOW_COLOR_A700 = "#FFD600";

    /**
     * Yellow color name.
     *
     * @var string
     */
    const YELLOW_COLOR_NAME = "yellow";
}
