<section class="push-banner m-t-70">
    <div class="container py-5">
        <div class="row">
            <div class="col-lg-6 col-md-12 mb-6">
                <div class="mb-4"><?php _e("We are your solution")?></div>
                <div class="position-relative">
                    <div class="font-three fs-40"><?php _e("Enhance Engagement & Retention with")?></div>
                    <div class="font-three fs-51 text-primary mb-4"><?php _e("Web Push Notifications")?></div>
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_rocket.png" class="position-absolute w-99 h-99 r-25 t-0">
                </div>
                <div class="mb-6 mw-450">
                    <?php _e("We help you design notifications such as images, text, or interactive components to capture user attention and encourage their interaction")?>
                </div>

                <div class="d-flex">
                    <a class="btn btn-primary me-3 click-menu" data-id="features" href="#features"><?php _e("Learn more")?></a>
                    <div class="position-relative">
                        <div class="position-absolute d-flex mn-25 l-90 text-nowrap fst-italic">
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_arrow_down.png" class="position-relative">
                            <div class="text-primary font-four mn-5 p-l-10"><?php _e("No credit card required")?></div>
                        </div>
                        <a class="btn btn-dark" href="<?php _ec( base_url("login") )?>"><?php _e("Get start now")?></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-12 mb-6">
                <div class="mw-550 position-relative p-l-30">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_banner.png" class="wp-90 position-relative zindex-1">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_banner_overplay.png" class="wp-80 position-absolute l-60 t-0">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_ov1.png" class="position-absolute r-40 t-20 zindex-3">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push_ov2.png" class="position-absolute l-0 b-70 zindex-3">
                    <div class="position-absolute bg-gray-200 d-flex justify-content-center align-items-center b-r-15 p-20 t-50 l-0 zindex-2">
                        <div class="w-40 h-40 b-r-10 bg-primary me-2 d-flex justify-content-center align-items-center text-white fs-20">
                            <i class="fal fa-tasks"></i>
                        </div>
                        <div>
                            <div class="fw-6"><?php _e("98K+")?></div>
                            <div class="text-gray-600 fs-12"><?php _e("Campaigns")?></div>
                        </div>
                    </div>

                    <div class="position-absolute bg-gray-200 d-flex justify-content-center align-items-center b-r-15 p-20 bn-20 r-100 zindex-2">
                        <div class="w-40 h-40 b-r-10 bg-primary me-2 d-flex justify-content-center align-items-center text-white fs-20">
                            <i class="fal fa-users-medical"></i>
                        </div>
                        <div>
                            <div class="fw-6"><?php _e("5K+")?></div>
                            <div class="text-gray-600 fs-12"><?php _e("Subscribers")?></div>
                        </div>
                    </div>

                    <div class="position-absolute bg-gray-200 d-flex justify-content-center align-items-center b-r-15 p-20 t-102 r-0 zindex-2">
                        <div class="w-40 h-40 b-r-10 bg-white me-2 d-flex justify-content-center align-items-center text-warning fs-20">
                            <i class="fas fa-star"></i>
                        </div>
                        <div>
                            <div class="fw-6"><?php _e("4.9")?></div>
                            <div class="text-gray-600 fs-12"><?php _e("Satisfaction")?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="container my-2">
    <div class="row align-items-center">
        <div class="col-sm-12 col-md-12 col-lg-3 fs-18 text-center text-md-center text-lg-left mb-4">
            <div><?php _e("Trusted by 20,000+ clients")?></div>
            <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="h-12">
        </div>
        <div class="col-sm-12 col-md-12 col-lg-9 mb-4">
            <div class="w-100 overflow-hidden d-flex align-items-center" id="marquee">
                <ul class="d-flex align-items-center mb-0">
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-1.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-2.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-3.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-4.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-5.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-6.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-7.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-8.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-9.png">
                    </li>
                    <li class="me-5 mb-0">
                        <img src="<?php _ec( get_frontend_url() )?>Assets/images/brands/brand-10.png">
                    </li>
                </ul>
            </div>
        </div>
    </div>
</section>


<section class="container p-t-30 p-b-30">
    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-primary font-one fw-6 mb-2"><span class="odometer" data-count-to="289"></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Total Digital Marketing Campaigns completed per month")?></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-primary font-one fw-6 mb-2"><span class="odometer" data-count-to="2579 "></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Notifications are scheduled without interruption every week")?></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="text-center mw-250 mx-auto">
                <div class="fs-50 text-primary font-one fw-6 mb-2"><span class="odometer" data-count-to="25789 "></span></div>
                <div class="fs-14 text-gray-600"><?php _e("Clients choose us to build brand through Web Push")?></div>
            </div>
        </div>
    </div>
</section>



<section class="push-one m-t-30" id="features">
    <div class="container">
        <div class="push_head mx-auto text-center font-one mb-6 px-5">
            <div class="fs-40 fw-6 mb-3 mw-900 mx-auto"><?php _e("Deliver visually engaging push notifications")?></div>
            <div class="fs-18 mw-950 mx-auto"><?php _e("It is essential for every modern website to include web notifications, as they offer a unique capability to send direct messages to customers, whether they are currently using the website or not")?></div>
        </div>

        <div>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-bell-on"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Notification Composer")?></div>
                        <div><?php _e("Create impressive web notifications by personalizing the title, body, link, icon, expiration, and sender domain. Additionally, you can enhance them with emojis, large images, and action buttons.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-wreath"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Welcome Notification")?></div>
                        <div><?php _e("Easily create automated welcome messages for new subscribers. Ensure timely engagement by having these messages sent immediately upon subscription.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-transporter-2"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Offline Notifications")?></div>
                        <div><?php _e("Schedule and send push notifications at any time and ensure delivery to subscribers, even when they're offline, so they receive notifications upon reconnecting to the internet.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-globe-europe"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Custom Domains & Branding")?></div>
                        <div><?php _e("Boost brand recognition and trust and drive engagement with custom domains and branding. Your custom-branded domain will be shown as the sender on all push notifications, enhancing trust and boosting click-through rates.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-bars"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Campaign Management")?></div>
                        <div><?php _e("The ability to effectively oversee and control all notification campaigns while also obtaining a more comprehensive understanding of the characteristics, behaviours, and preferences of the target audience at each campaign.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-calendar-alt"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Notification Calendar")?></div>
                        <div><?php _e("Easily visualize all your scheduled notifications, allowing you to review and fine-tune them before they go live. With a clear overview of your marketing plan, you can ensure consistency, creativity, and strategic alignment in every notification.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-badge-sheriff"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Auto Segmentation")?></div>
                        <div><?php _e("Segment push notifications to target the appropriate subscribers at the optimal time, maximizing your results. Create dynamic segments based on user behaviour to enhance the effectiveness of your messaging.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-vector-square"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Manual Segmentation")?></div>
                        <div><?php _e("Create segment users manually based on subscription pages, site interactions, device type, location, and other relevant factors. Group users by common characteristics to send target messages to them according to their interests.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-paper-plane"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Sent Notification Analytics")?></div>
                        <div><?php _e("Gain a comprehensive understanding of the effectiveness of your notifications in reaching and engaging your audience. Assess the impact of your messaging to optimize engagement strategies.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-users"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Subscribers Analytics")?></div>
                        <div><?php _e("Track and analyze the fluctuations in subscriber numbers over a specified period. Evaluate these changes to inform strategic adjustments and improve subscriber retention and growth.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-info"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Subscribers Information Analytics")?></div>
                        <div><?php _e("Gain in-depth insights into your target subscribers, encompassing their interests, visit frequency, location, device preferences, and more. Utilize this comprehensive data to tailor your strategies and enhance audience engagement.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-globe-stand"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Geolocation Analytics")?></div>
                        <div><?php _e("Obtain valuable insights into your subscribers' countries and other pertinent geographic data globally. Leverage this information to refine your targeting strategies and optimize outreach efforts.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-phone-laptop"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Brower/Device Analytics")?></div>
                        <div><?php _e("Analyze the browsers and device types your subscribers use to access your site, along with corresponding click-through rate (CTR) insights. Utilize this data to optimize your content and improve user engagement across different browsers and devices.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-window-restore"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Customizable Opt-Ins")?></div>
                        <div><?php _e("Increase your subscriber base by implementing well-timed, targeted push notification opt-ins. Configure these themes to trigger at the perfect moment for maximum signups, using criteria like time on the page, scroll percentage, or clicks on specific elements.")?></div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="p-30 pb-0 mb-4 h-100 border b-r-10">
                        <div class="w-40 h-40 b-r-10 d-flex justify-content-center align-items-center mb-3 bg-light-primary text-primary fs-22"><i class="fal fa-th"></i></div>
                        <div class="fw-6 mb-1"><?php _e("Customizable Widget")?></div>
                        <div><?php _e("Collecting subscribers on your website is effortless with the widget, whether using a subscription prompt, floating action button or subscribe button. Customize every aspect, including text, colour, position, icon, and additional design elements.")?></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="push-two m-t-90 m-b-90">
    <div class="container">
        <div class="push_head mx-auto text-center font-one mb-6 px-5">
            <div class="fs-40 fw-6 mb-3 mw-650 mx-auto"><?php _e("Compatibility with popular web browsers")?></div>
            <div class="fs-18 mw-850 mx-auto"><?php _e("Our platform enables the sending of desktop and browser notifications across Google Chrome, Safari, Firefox, and other major browsers.")?></div>
        </div>

        <div class=" d-flex justify-content-center">
            <div class="row">
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_chome.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Chrome")?></div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_firefox.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Firefox")?></div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_safari.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Safari")?></div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_edge.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Edge")?></div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_opera.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Operar")?></div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-sm-4 col-4">
                    <div class="text-center">
                        <div>
                            <img src="<?php _ec( get_frontend_url() )?>Assets/images/browser_samsung.png">
                        </div>
                        <div class="text-gray-700"><?php _e("Samsung")?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="push-three p-t-90 p-b-90 bg-primary text-white">
    <div class="container">
        <div class="push_head mx-auto text-center font-one px-5">
            <div class="fs-40 fw-6 mb-3 mw-1200 mx-auto"><?php _e("Let Us Do More For You")?></div>
            <div class="fs-18 mw-1500 mx-auto"><?php _e("Integrating web push notifications can yield substantial benefits for your business.")?></div>
        </div>
    </div>
</section>

<section class="push-three p-t-70 p-b-70">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-md-6 order-lg-first order-md-first order-first">
                <div class="mw-550">
                    <div class="fw-6 fs-25 mw-450 mb-4"><?php _e("Customer engagement strategy")?></div>
                    <div class="fs-16">
                        <?php _e("We enable you to enhance your customer engagement strategy by driving users back to your site, even when they are browsing elsewhere")?>
                    </div>
                </div>
            </div>
            <div class="col-md-6 order-lg-last order-md-last order-last">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/push-b1.png" class="wp-80">
            </div>
        </div>
    </div>
</section>

<section class="push-three p-t-70 bg-gray-100 p-b-70">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-md-6 order-lg-last order-md-first order-first">
                <div class="mw-550">
                    <div class="fw-6 fs-25 mw-450 mb-4"><?php _e("Turn Site Visitors into Subscribers")?></div>
                    <div class="fs-16"><?php _e("Visitors can easily subscribe to web push notifications with a single click, without needing to provide personal information")?></div>
                </div>
            </div>
            <div class="col-md-6 order-lg-first order-md-last order-last">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/push-b2.png" class="wp-80">
            </div>
        </div>
    </div>
</section>

<section class="push-three p-t-70 p-b-70">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-md-6 order-lg-first order-md-first order-first">
                <div class="mw-550">
                    <div class="fw-6 fs-25 mw-450 mb-4"><?php _e("Higher Conversion Rates")?></div>
                    <div class="fs-16">
                        <?php _e("Research indicates that web push notifications achieve conversion rates thirty times higher than email")?>
                    </div>
                </div>
            </div>
            <div class="col-md-6 order-lg-last order-md-last order-last">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/push-b3.png" class="wp-80">
            </div>
        </div>
    </div>
</section>

<section class="push-three bg-gray-100 p-t-70 p-b-70">
    <div class="container">
        <div class="d-flex justify-content-center">
            <div class="row justify-content-center align-items-center">
                <div class="col-md-6 order-lg-last order-md-first order-first">
                    <div class="mw-550">
                        <div class="fw-6 fs-25 mw-450 mb-4"><?php _e("Increased website traffic")?></div>
                        <div class="fs-16"><?php _e("Keep your brand in users' minds and provide valuable content, which can lead to higher traffic, better visibility, and increased sales opportunities.")?></div>
                    </div>
                </div>
                <div class="col-md-6 order-lg-first order-md-last order-last">
                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/push-b4.png" class="wp-80">
                </div>
            </div>
        </div>
    </div>
</section>

<section class="push-three p-t-70 p-b-70">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-md-6 order-lg-first order-md-first order-first">
                <div class="mw-550">
                    <div class="fw-6 fs-25 mw-450 mb-4"><?php _e("Deliver Personalized Notifications")?></div>
                    <div class="fs-16">
                        <?php _e("Customize notifications so that they are specifically relevant to the unique preferences or desires of an individual or group")?>
                    </div>
                </div>
            </div>
            <div class="col-md-6 order-lg-last order-md-last order-last">
                <img src="<?php _ec( get_frontend_url() )?>Assets/images/push-b5.png" class="wp-80">
            </div>
        </div>
    </div>
</section>

<section class="push-three p-t-70 p-b-70 bg-primary text-white">
    <div class="container">
        <div class="row mx-auto font-one px-5">
            <div class="col-md-5 offset-md-1 mb-3 mt-3 text-center text-md-left text-sm-center text-xs-left"><?php _e("Experience our service for free, with no commitments or payment information required.")?></div>
            <div class="col-md-5 mb-3 mt-3">
                <div class="d-flex justify-content-center">
                    <div><a class="btn btn-white text-primary" href="<?php _ec( base_url("login") )?>"><?php _e("Get started")?></a></div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="sp-rating p-t-90 p-b-90">

    <div class="container">
        <div class="mx-auto text-center font-one mb-6 px-5">
            <div class="headline fs-40 fw-6 mb-3 mw-900 mx-auto"><?php _e("What <span class='text-warning'>our clients</span> say", 0)?></div>
            <div class="headline_desc fs-18 mw-650 mx-auto text-gray-700"><?php _e("Our clients praise us for our great results, personable service and expert knowledge. Here are what just a few of them had to say.")?></div>
        </div>

        <div class="position-relative">
            <div class="py-3 position-relative mw-1000 mx-auto">
                <div class="mw-550 mx-auto text-center position-relative mx-auto zindex-2">
                    <div class="owl-carousel rating-slider owl-theme">
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Complete Tool for Social Media Agencies")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("It's amazing to have found a tool that integrates all the necessary resources for a Social Media Marketing agency into one comprehensive and accessible platform.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/1.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("John Carter")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Digital Marketing Manager")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Efficient Marketing Management and Expanded Presence")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("With this platform, I can efficiently manage my marketing efforts, reduce the time spent on tasks, and expand my presence in multiple locations effortlessly.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/2.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Emma Grace")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("SEO Specialist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Comprehensive Analytics and Impressive Post Management")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("I really appreciate this platform for its comprehensive analytics, ability to schedule in bulk, versatile scheduling options, and impressive post appearance.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/3.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Liam Scott")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Social Media Strategist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("One Hour a Week, Zero Social Media Worries")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("It’s fantastic to spend just an hour each week adding to my library and then not have to worry about social media for the rest of the week.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/4.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Ava Rose")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Social Media Analyst")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Doubling Growth and 68% More Productivity")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("Thanks to this tool, our company has grown doubled. Without it, we would have been floundering, but now we’re accomplishing 68% more work with the same team.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/5.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Noah James")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Content Manager")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="position-relative pe-3 b-r-10 p-30 me-4">
                            <div class="text-gray-500 fs-30 zindex-1 opacity-25 r-20 t-7"><i class="fad fa-quote-left"></i></div>
                            <div class="position-relative zindex-2">
                                <div class="w-110 mb-3 text-center mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/stars.png" class="w-100 d-inline-block">
                                </div>
                                <div class="fw-6 fs-18 mb-3"><?php _e("Easy Scheduling and Metrics with the team")?></div>
                                <div class="mb-3 text-gray-700">
                                    <?php _e("This incredible platform has unified our team. It offers easy post scheduling, smooth team collaboration, and centralized metric sharing with all stakeholders, all in one convenient place.")?>
                                </div>
                                <div class="mx-auto">
                                    <img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/6.jpg" class="w-120 h-120 b-r-100 me-2 mb-3 d-inline-block">
                                    <div>
                                        <div class="fw-6 text-warning fs-16"><?php _e("Olivia Claire")?></div>
                                        <div class="text-gray-600 fs-12"><?php _e("Marketing Automation Specialist")?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="position-absolute w-100 h-100 t-0 rating-slider-nav d-none d-lg-block d-md-block d-xs-none">
                    <li class="rounded-circle border-dashed border-warning p-1  w-60 h-60 position-absolute l-70 t-30 bg-active-warning active" data-index="0">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/1.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-95 h-95 position-absolute l-0 t-220 bg-active-warning" data-index="1">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/2.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute l-70 b-30 bg-active-warning" data-index="2">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/3.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute r-70  t-30 bg-active-warning" data-index="3">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/4.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-95 h-95 position-absolute r-0 t-220 bg-active-warning" data-index="4">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/5.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                    <li class="rounded-circle border-dashed border-warning p-1  w-74 h-74 position-absolute r-70 b-40 bg-active-warning" data-index="5">
                        <a href="javascript:void(0);"><img src="<?php _ec( get_frontend_url() )?>Assets/images/ratings/6.jpg" class="rounded-circle w-100 h-100"></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

</section>
<section class="bg-gray-100 p-t-150 p-b-150 position-relative overflow-hidden">
    <img src="<?php _ec( get_frontend_url() )?>Assets/images/shape-1.png" class="position-absolute ln-120 tn-200 mw-600 opacity-50">
    <img src="<?php _ec( get_frontend_url() )?>Assets/images/shape-2.png" class="position-absolute rn-120 bn-200 mw-600 opacity-25">
    <div class="mx-auto container text-center position-relative zindex-1">
        <div class="fs-40 fw-9 mb-4">
            <?php _e("Join over 5,000 satisfied customers who trust us to help them manage their web push notifications")?>
        </div>
        <div class="fs-16 text-gray-700 mb-4"><?php _e("You can get started in mere minutes.")?></div>
        <a class="btn btn-dark" href="<?php _ec( base_url("login") )?>"><?php _e("Sign up for Free")?></a>
    </div>
</section>