"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.patchButtonsMessage = void 0;
const createButton = (button) => {
    var _a, _b;
    switch (button === null || button === void 0 ? void 0 : button.type) {
        case 'url':
            return {
                name: 'cta_url',
                buttonParamsJson: JSON.stringify({
                    display_text: ((_a = button === null || button === void 0 ? void 0 : button.buttonText) === null || _a === void 0 ? void 0 : _a.displayText) || '',
                    id: button.id,
                    url: button.url,
                    disabled: false
                })
            };
        default:
            return {
                name: 'quick_reply',
                buttonParamsJson: JSON.stringify({
                    display_text: ((_b = button === null || button === void 0 ? void 0 : button.buttonText) === null || _b === void 0 ? void 0 : _b.displayText) || '',
                    id: button.buttonId,
                    disabled: false
                })
            };
    }
};
const createInteractiveButtonsFromButton = (buttons) => {
    const buttonsArray = [];
    buttons === null || buttons === void 0 ? void 0 : buttons.map((button) => {
        buttonsArray.push(createButton(button));
    });
    return buttonsArray;
};
const getType = (message) => {
    if (message.image || message.imageMessage) {
        return 'image';
    }
    else if (message.video || message.videoMessage) {
        return 'video';
    }
    else if (message.document || message.documentMessage) {
        return 'document';
    }
    return 'text';
};
const createHeader = (message) => {
    var _a;
    if (!message) {
        return {
            title: '',
            hasMediaAttachment: false
        };
    }
    let hasMedia = false;
    const MediaType = getType(message) + 'Message';
    if (message.documentMessage || message.imageMessage || message.videoMessage) {
        hasMedia = true;
    }
    const header = {
        title: hasMedia ? (_a = message[MediaType]) === null || _a === void 0 ? void 0 : _a.caption : '',
        hasMediaAttachment: hasMedia,
        [MediaType]: message[MediaType]
    };
    return header;
};
const convertInteractiveHeaderToTemplateMedia = (message) => {
    if (message.hasMediaAttachment) {
        if (message.documentMessage) {
            return message.documentMessage;
        }
        else if (message.imageMessage) {
            return message.imageMessage;
        }
        else if (message.videoMessage) {
            return message.videoMessage;
        }
    }
    return null;
};
const convertButtonsToInteractive = (msg) => {
    var _a;
    msg = JSON.parse(JSON.stringify(msg));
    const header = createHeader(msg);
    return {
        documentWithCaptionMessage: {
            message: {
                interactiveMessage: {
                    footer: {
                        text: msg === null || msg === void 0 ? void 0 : msg.footerText
                    },
                    body: {
                        text: msg === null || msg === void 0 ? void 0 : msg.contentText
                    },
                    header,
                    nativeFlowMessage: {
                        buttons: createInteractiveButtonsFromButton((_a = msg === null || msg === void 0 ? void 0 : msg.buttons) !== null && _a !== void 0 ? _a : [])
                    }
                }
            }
        }
    };
};
const createButtonsFromInteractive = (buttons) => {
    const buttonsArray = [];
    buttons === null || buttons === void 0 ? void 0 : buttons.map((button) => {
        var _a, _b;
        return buttonsArray.push({
            buttonId: ((_a = button === null || button === void 0 ? void 0 : button.buttonParamsJson) === null || _a === void 0 ? void 0 : _a.id) || '',
            buttonText: {
                displayText: ((_b = button === null || button === void 0 ? void 0 : button.buttonParamsJson) === null || _b === void 0 ? void 0 : _b.display_text) || ''
            },
            type: 1,
        });
    });
    return buttonsArray;
};
const createTemplateButtonsFromInteractive = (buttons) => {
    const buttonsArray = [];
    buttons === null || buttons === void 0 ? void 0 : buttons.map((button, index) => {
        if (button.name === 'quick_reply') {
            const quickReplyButton = JSON.parse(button.buttonParamsJson);
            const quick_reply_button = {
                displayText: quickReplyButton.display_text,
                id: quickReplyButton.id,
            };
            buttonsArray.push({ quickReplyButton: quick_reply_button, index: index + 1 });
        }
        else if (button.name === 'cta_url') {
            const ctaUrlButton = JSON.parse(button.buttonParamsJson);
            const cta_url_button = {
                displayText: ctaUrlButton.display_text,
                url: ctaUrlButton.url,
                //@ts-ignore
            };
            buttonsArray.push({ urlButton: cta_url_button, index: index + 1 });
        }
        else if (button.name === 'cta_copy') {
            const ctaCopyButton = JSON.parse(button.buttonParamsJson);
            const cta_copy_button = {
                displayText: ctaCopyButton.display_text,
                url: `https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code=${ctaCopyButton.copy_code}`
            };
            buttonsArray.push({ urlButton: cta_copy_button, index: index + 1 });
        }
        else if (button.name === 'cta_call') {
            const ctaCallButton = JSON.parse(button.buttonParamsJson);
            const cta_call_button = {
                displayText: ctaCallButton.display_text,
                phoneNumber: ctaCallButton.phone_number
            };
            buttonsArray.push({ callButton: cta_call_button, index: index + 1 });
        }
    });
    return buttonsArray;
};
const convertInteractiveToTemplate = (msg) => {
    var _a, _b, _c, _d;
    const media = convertInteractiveHeaderToTemplateMedia(msg.header);
    const getMediaType = (header) => {
        if (header.hasMediaAttachment) {
            if (header.documentMessage) {
                return 'documentMessage';
            }
            else if (header.imageMessage) {
                return 'imageMessage';
            }
            else if (header.videoMessage) {
                return 'videoMessage';
            }
        }
    };
    const containsMedia = getMediaType(msg.header);
    return {
        hydratedContentText: ((_a = msg.body) === null || _a === void 0 ? void 0 : _a.text) || '',
        hydratedFooterText: ((_b = msg.footer) === null || _b === void 0 ? void 0 : _b.text) || '',
        hydratedButtons: createTemplateButtonsFromInteractive((_d = (_c = msg.nativeFlowMessage) === null || _c === void 0 ? void 0 : _c.buttons) !== null && _d !== void 0 ? _d : []),
        imageMessage: containsMedia === 'imageMessage' ? media : undefined,
        videoMessage: containsMedia === 'videoMessage' ? media : undefined,
        documentMessage: containsMedia === 'documentMessage' ? media : undefined
    };
};
const createInteractiveHeaderFromTemplate = (msg) => {
    var _a, _b, _c, _d, _e, _f;
    const header = ((_a = msg.hydratedTemplate) === null || _a === void 0 ? void 0 : _a.imageMessage) || ((_b = msg.hydratedTemplate) === null || _b === void 0 ? void 0 : _b.videoMessage) || ((_c = msg.hydratedTemplate) === null || _c === void 0 ? void 0 : _c.documentMessage);
    const hasMedia = !!header;
    return {
        title: hasMedia ? (header === null || header === void 0 ? void 0 : header.caption) || '' : '',
        hasMediaAttachment: hasMedia,
        imageMessage: (_d = msg.hydratedTemplate) === null || _d === void 0 ? void 0 : _d.imageMessage,
        videoMessage: (_e = msg.hydratedTemplate) === null || _e === void 0 ? void 0 : _e.videoMessage,
        documentMessage: (_f = msg.hydratedTemplate) === null || _f === void 0 ? void 0 : _f.documentMessage
    };
};
const createInteractiveButtonsFromTemplate = (buttons) => {
    const buttonsArray = [];
    buttons === null || buttons === void 0 ? void 0 : buttons.map((button) => {
        var _a;
        if (button.quickReplyButton) {
            const quickReplyButton = button.quickReplyButton;
            const quick_reply_button = {
                display_text: quickReplyButton.displayText || '',
                id: quickReplyButton.id || '',
                disabled: false
            };
            buttonsArray.push({ name: 'quick_reply', buttonParamsJson: JSON.stringify(quick_reply_button) });
        }
        else if (button.urlButton) {
            const urlButton = button.urlButton;
            // check if url contains https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code= then it is a copy button
            if ((_a = urlButton.url) === null || _a === void 0 ? void 0 : _a.includes('https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code=')) {
                const cta_copy_button = {
                    display_text: urlButton.displayText || '',
                    id: '',
                    copy_code: urlButton.url.split('https://www.whatsapp.com/otp/code/?otp_type=COPY_CODE&code=')[1],
                    disabled: false
                };
                buttonsArray.push({ name: 'cta_copy', buttonParamsJson: JSON.stringify(cta_copy_button) });
            }
            else {
                const cta_url_button = {
                    display_text: urlButton.displayText || '',
                    id: '',
                    url: urlButton.url || '',
                    disabled: false
                };
                buttonsArray.push({ name: 'cta_url', buttonParamsJson: JSON.stringify(cta_url_button) });
            }
        }
        else if (button.callButton) {
            const callButton = button.callButton;
            const cta_call_button = {
                display_text: callButton.displayText || '',
                id: '',
                phone_number: callButton.phoneNumber || '',
                disabled: false
            };
            buttonsArray.push({ name: 'cta_call', buttonParamsJson: JSON.stringify(cta_call_button) });
        }
    });
    return buttonsArray;
};
const convertTemplateToInteractive = (msg) => {
    var _a, _b, _c;
    const header = createInteractiveHeaderFromTemplate(msg);
    return {
        footer: {
            text: ((_a = msg.hydratedTemplate) === null || _a === void 0 ? void 0 : _a.hydratedFooterText) || '',
        },
        body: {
            text: ((_b = msg.hydratedTemplate) === null || _b === void 0 ? void 0 : _b.hydratedContentText) || '',
        },
        header,
        nativeFlowMessage: {
            buttons: createInteractiveButtonsFromTemplate(((_c = msg.hydratedTemplate) === null || _c === void 0 ? void 0 : _c.hydratedButtons) || [])
        }
    };
};
const patchWebButtonsMessage = (msg) => {
    var _a, _b;
    if ((_b = (_a = msg.documentWithCaptionMessage) === null || _a === void 0 ? void 0 : _a.message) === null || _b === void 0 ? void 0 : _b.interactiveMessage) {
        const templateMessage = convertInteractiveToTemplate(msg.documentWithCaptionMessage.message.interactiveMessage);
        msg = {
            templateMessage: {
                fourRowTemplate: {},
                hydratedTemplate: templateMessage
            }
        };
    }
    return msg;
};
const patchButtonsMessage = (msg, currentJid) => {
    const isMobile = !(currentJid === null || currentJid === void 0 ? void 0 : currentJid.includes(':')) || false;
    if (!isMobile) {
        return patchWebButtonsMessage(msg);
    }
    else {
        if (msg.templateMessage) {
            msg = {
                documentWithCaptionMessage: {
                    message: {
                        interactiveMessage: convertTemplateToInteractive(msg.templateMessage)
                    }
                }
            };
        }
    }
    // need to patch sender Device
    return msg;
};
exports.patchButtonsMessage = patchButtonsMessage;
